#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = 2100;
const int M = 1e9 + 7;

int n;
int64 d;
int x;

int dp[N][N];
int sum[N];

int getSum(int l, int r) {
	int res = (sum[r] - (l > 0 ? sum[l - 1] : 0) + M);
	if (res >= M)
		res -= M;
	return res;
}

int power(int a, int b) {
	if (b == 0)
		return 1;
	int res = power(a, b / 2);
	res = (1ll * res * res) % M;
	if (b & 1)
		res = (1ll * res * a) % M;
	return res;
}

int inv(int64 x) {
	return power(x % M, M - 2);
}

void solve() {
	x--;
	for (int i = 0; i <= n; i++)
		for (int j = 0; j <= n; j++)
			dp[i][j] = 0;
	dp[0][0] = 1;
	for (int i = 1; i <= n; i++) {
		for (int j = 0; j <= n; j++) {
			sum[j] = dp[i - 1][j];
			if (j > 0) {
				sum[j] = (sum[j] + sum[j - 1]);
				if (sum[j] >= M)
					sum[j] -= M;
			}
		}
		for (int j = 0; j <= n; j++) {
			dp[i][j] = getSum(max(0, j - x), j - 1);
		}
	}
	int result = 0, cur = 1;
	for (int i = 0; i <= n && i <= d; i++) {
		result = (result + 1ll * cur * dp[i][n]) % M;
		cur = (((1ll * cur * (d - i)) % M) * inv(i + 1)) % M;
	}
	printf("%d\n", result);
}

int main() {
#ifdef LOCAL42
#define TASK "G"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	while (scanf("%d"LLD"%d", &n, &d, &x) == 3 && (n != 0 || d != 0 || x != 0)) {
		solve();
	}
	eprintf("Clock: %.10lf\n", 1.0 * clock() / CLOCKS_PER_SEC);
	return 0;
}
